namespace App\Http\Controllers\Seller;

use App\Http\Controllers\Controller;
use App\Models\OrderItem;
use Illuminate\Support\Facades\Auth;

class OrderController extends Controller
{
    public function index()
    {
        $orderItems = OrderItem::with(['order', 'inventoryItem.product'])
            ->where('seller_user_id', Auth::id())
            ->get();

        return view('seller.orders.index', compact('orderItems'));
    }

    public function show($id)
    {
        $orderItems = OrderItem::with(['order', 'inventoryItem.product'])
            ->where('seller_user_id', Auth::id())
            ->where('order_id', $id)
            ->get();

        if ($orderItems->isEmpty()) {
            abort(403, 'Unauthorized action.');
        }

        return view('seller.orders.show', compact('orderItems'));
    }
}